/*******************************************************************************
 *
 *      A U D I O   R E C O R D E R
 *
 *      Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#ifndef SYSTEM_H
#define SYSTEM_H

#ifdef __cplusplus
extern "C" {
#endif
#include "genericTypeDefs.h"
#include <plib.h>

//System Level Defines 
#define SYS_FREQ                        80000000L
#define FCY                             SYS_FREQ
#define FPB                             SYS_FREQ / 2

#define RED_LED_ON                      PORTSetBits(IOPORT_F, BIT_3)
#define RED_LED_OFF                     PORTClearBits(IOPORT_F, BIT_3)
#define RED_LED_TOGGLE                  PORTToggleBits(IOPORT_F, BIT_3)
#define BAT_CHG_500                     PORTSetBits(IOPORT_D, BIT_9)
#define BAT_CHG_100                     PORTClearBits(IOPORT_D, BIT_9)
#define BAT_STAT1                       PORTBbits.RB8
#define BAT_STAT2                       PORTBbits.RB9
#define PGOOD                           PORTBbits.RB10

#define	ROM	const

/* Event Queue *****************************************************************
 * Events have a type, event code and and x and y coordinate (for touch events)
 */
enum EVTYPE{ START, TOUCH, TOUCH_RELEASE, FS_ERROR, ERROR, TICK, SD_CARD, AUDIO, USB_EVT };
    
typedef struct {
    enum EVTYPE type;
    UINT16 code;
    INT16 x;
    INT16 y;
}EVENT;

/* Touchscreen events */
enum { INVALID = 0, PRESS, STILL_PRESS, RELEASE };

/* SD Card Event Codes */
enum { SD_IN = 12, SD_OUT };

/* Tick Event Codes */
enum { HALF_SEC, ONE_SEC };

/* Audio Event Codes */
enum { REC_STOP, PLAY_STOP, PLAY_STOP_ATEND };

/* USB Codes */
enum { CONNECTED, DISCONNECTED, ATTACHED, READY };

/* Error Event Codes */
enum { NO_SD = 100, MALLOC, NO_RIFF, NO_WAVE, NO_FMT, NOT_PCM, NOT_2CH, BAD_RATE,
        BAD_DEPTH, NO_DATA, DISK_FULL, PATH_LONG, UNKNOWN, NO_HEX_FILE };

/** Enqueue an Event
 * @param evt Event to post to the queue
 */
void enqueueEvent(enum EVTYPE type, UINT16 code, INT16 x, INT16 y);
void enqueueHighPriorityEvent(enum EVTYPE type, UINT16 code, INT16 x, INT16 y);

/** Fatal error*/
void fatalError(UINT32 code);

#ifdef __cplusplus
}
#endif

#endif
